﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Browser;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Media.Imaging;
using System.Windows.Resources;

namespace GraphicChart
{
    public partial class Page : UserControl
    {

        private List<string> l1;        // tu je ulozeny list stringov pre selekciu, teda ak sa kliklo na nejekay obdlznik
        private List<string> sort;      // tu je ulozeny list stringov pre selekciu ak sa sortovalo "1a" graf 1 ascending

        public Page()
        {
            InitializeComponent();

            Application.Current.Host.Content.FullScreenChanged += new EventHandler(ScreenChanged);


            l1 = new List<string>();
            sort = new List<string>();
            
            // vytovrenie lokalnych premennych pre kazdy graf nacitanim dat z XML a inicializovanie grafov
            Core.XmlParsing xmlParsing = new Core.XmlParsing(LayoutRoot, l1, sort, null, null);

            // Button ktory prpene graf do FullScreen modu/////////////////////////////////////////////
            FullScreenButton.Cursor = Cursors.Hand;
            FullScreenButton.Click += delegate(object sender, RoutedEventArgs e)
            {
                FullScreen(sender, e);
            };

            // Button ktory resetuje graf//////////////////////////////////////////////////////////////
            DisplayMenuButton.Cursor = Cursors.Hand;
            DisplayMenuButton.Click += delegate(object sender, RoutedEventArgs e)
            {
                ShowHideMenu(sender, e);
            };

            // Button ktory resetuje graf//////////////////////////////////////////////////////////////
            ResetButton.Cursor = Cursors.Hand;
            ResetButton.Click += delegate(object sender, RoutedEventArgs e)
            {
                ResetGraf(sender, e);
            };

            // Button ktory ulozi graf//////////////////////////////////////////////////////////////
            SaveButton.Cursor = Cursors.Hand;
            SaveButton.Click += delegate(object sender, RoutedEventArgs e)
            {
                SaveGraf(sender, e);
            };

            // Button ktory nacita graf//////////////////////////////////////////////////////////////
            LoadButton.Cursor = Cursors.Hand;
            LoadButton.Click += delegate(object sender, RoutedEventArgs e)
            {
                LoadGraf(sender, e);
            };

            // Button ktory priblizi graf//////////////////////////////////////////////////////////////
            ZoomInButton.Cursor = Cursors.Hand;
            ZoomInButton.Click += delegate(object sender, RoutedEventArgs e)
            {
                ZoomIn(sender, e);
            };

            // Button ktory oddiali graf//////////////////////////////////////////////////////////////
            ZoomOutButton.Cursor = Cursors.Hand;
            ZoomOutButton.Click += delegate(object sender, RoutedEventArgs e)
            {
                ZoomOut(sender, e);
            };

            // Button ktory resetuje ZOOM//////////////////////////////////////////////////////////////
            ZoomResetButton.Cursor = Cursors.Hand;
            ZoomResetButton.Click += delegate(object sender, RoutedEventArgs e)
            {
                ZoomReset(sender, e);
            };
        }


        /// <summary>
        /// Button ktory prpene graf do FullScreen modu
        /// </summary>
        private void FullScreen(object sender, RoutedEventArgs e)
        {
            Application.Current.Host.Content.IsFullScreen = !Application.Current.Host.Content.IsFullScreen;
        }


        /// <summary>
        /// Ak sa zmenila zobrazenie normalna obrazovka/FullScreen a naopak
        /// </summary>
        private void ScreenChanged(object sender, EventArgs e)
        {
            ChangeScale();
        }


        public void ChangeScale()
        {
            if (Application.Current.Host.Content.IsFullScreen == false)
            {
                scale.ScaleX = 1;
                scale.ScaleY = 1;
            }
            else
            {
                // rozlisenie PC
                ScriptObject screen = (ScriptObject)HtmlPage.Window.GetProperty("screen");
                double bWidth = (double)screen.GetProperty("width");
                double bHeight = (double)screen.GetProperty("height");
                scale.ScaleX = 1;
                scale.ScaleY = 1;
                int sWidth = Convert.ToInt32(App.Current.Resources["SilWidth"]);
                int sHeight = Convert.ToInt32(App.Current.Resources["SilHeight"]);
                double tmpW = bWidth / sWidth;
                double tmpH = bHeight / sHeight;
                if (tmpW < tmpH)
                {
                    scale.ScaleX = tmpW;
                    scale.ScaleY = tmpW;
                }
                else
                {
                    scale.ScaleX = tmpH;
                    scale.ScaleY = tmpH;
                }
            }
        }
        

        /// <summary>
        /// Zobraz/Schovaj menu
        /// </summary>
        private void ShowHideMenu(object sender, RoutedEventArgs e)
        {
            if (ResetButton.Visibility == Visibility.Visible)
            {
                ResetButton.Visibility = Visibility.Collapsed;
                SaveButton.Visibility = Visibility.Collapsed;
                LoadButton.Visibility = Visibility.Collapsed;
                ZoomInButton.Visibility = Visibility.Collapsed;
                ZoomOutButton.Visibility = Visibility.Collapsed;
                ZoomResetButton.Visibility = Visibility.Collapsed;
            }
            else {
                ResetButton.Visibility = Visibility.Visible;
                SaveButton.Visibility = Visibility.Visible;
                LoadButton.Visibility = Visibility.Visible;
                ZoomInButton.Visibility = Visibility.Visible;
                ZoomOutButton.Visibility = Visibility.Visible;
                ZoomResetButton.Visibility = Visibility.Visible;
            }
                
        }

        /// <summary>
        /// Resetuje Graf
        /// </summary>
        private void ResetGraf(object sender, RoutedEventArgs e)
        {
            LayoutRoot.Children.Clear();
            List<string>  tmp = new List<string>();
            scale.ScaleX = 1;
            scale.ScaleY = 1;
            Core.XmlParsing xmlParsing = new Core.XmlParsing(LayoutRoot, tmp, tmp, null, null);
            ChangeScale();
        }

        /// <summary>
        /// Ulozi Graf
        /// </summary>
        private void SaveGraf(object sender, RoutedEventArgs e)
        {
            Core.XmlParsing xmlParsing = new Core.XmlParsing(LayoutRoot, "s");
        }

        /// <summary>
        /// Nacita Graf
        /// </summary>
        private void LoadGraf(object sender, RoutedEventArgs e)
        {
            Core.XmlParsing xmlParsing = new Core.XmlParsing(LayoutRoot, "l");
        }

        /// <summary>
        /// Button ktory priblizi graf
        /// </summary>
        private void ZoomIn(object sender, RoutedEventArgs e)
        {
            scale.ScaleX = scale.ScaleX * 1.05;
            scale.ScaleY = scale.ScaleY * 1.05;
        }

        /// <summary>
        /// Button ktory oddiali graf
        /// </summary>
        private void ZoomOut(object sender, RoutedEventArgs e)
        {
            scale.ScaleX = scale.ScaleX / 1.05;
            scale.ScaleY = scale.ScaleY / 1.05;
        }

        /// <summary>
        /// Button ktory resetuje Zoom
        /// </summary>
        private void ZoomReset(object sender, RoutedEventArgs e)
        {
            scale.ScaleX = 1;
            scale.ScaleY = 1;
        }

    }
}
